c     -------------------------------------------------------------------DISPS
      subroutine disps (ndatam,propma,ndof,iele,iface,d0,f,s,iadres,
     +nck,icode,idat,coord,dummy,cres,stressn,fr,ener0,diss0,btol,windo,
     +lmdat,ekdat,bdat,prd1,porel,enerb0)
c
      implicit double precision (a-h,o-z)
      dimension propma(1),ndof(1),iele(1),stressn(1),iface(1),d0(1),
     +f(1),s(1),iadres(1),nck(1),icode(1),idat(1),coord(1),dummy(1),
     +cres(1),fr(1),windo(1),lmdat(1),ekdat(1),bdat(1),porel(1)
c
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /andat/ rdis,kswt,kdis,kfrc,ktmp,khdr,kseis,keig,n1dof,
     +n2dof
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      common /bacup/ nvec,imass,idead,iep0,ifc,idis,idisp,irest,ifals(4)
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
c
c     Master routine controlling crack propagation under incremental specified
c     loads/displacements/reservoir filling.
c
c                                  Sudip S. Bhattacharjee/Jan.30,1992/McGill
c                                 latest modification on Apr. 29,1992/McGill
c                                       modified         /Sep.24,1993/Ecole
      mtime=0
      itime=0
      kstiff=0
      call telapsd (mtime,itime)
c      kstep=max0 (kdis,kfrc,khdr)
      call nopen (-ntr,'enr')
c      call nopen (-nt9,'crk')
      time=0.0
      work=0.d0
      enerin=0.d0
      dissi=0.d0
      write (ntr,1002) time,work,enerin,dissi,dissi,prd1,wlf,mtime
      nvec=nvec+1
      idisp=nvec
      nvec=nvec+1
      irest=nvec
      call bakup (f,neq,idisp,windo)
      call bakup (fr,neq,irest,windo)
      call copr (fr,dummy,numeqn)
      call assmk0 (iadres,s,lmdat,ekdat,icrack)
      call optsol (s,fr,iadres,numeqn,1,1,1)
      istep=1
      time=1.0
      if (rdis .ne. 0.d0) then
          rdisp0=f(n2dof)-f(n1dof)
      endif
      trdis=0.d0
      pfac=1.d0
      pfai=0.d0
      call outp (iskis,iskip)
      jskis=0
      jskip=0
   50 continue
      kstep=max0(kdis,kfrc,khdr)
      if (istep .gt. kstep) then
          if (jskis .ne. 0) then
             time=time-1.d0
             call save (f,fr,cres,dummy,ndof,time)
          endif
   	    istep=istep-1
     	    write (not,1000) istep
	       write (ntm,1000) istep
	   return
      endif 
      write (not,1001) istep
      write (ntm,1001) istep
      call formfs (f,fr,dummy,s,iadres,numeqn,neq,kfrc,kdis,ifc,idis,
     +trdis,pfac,pfai,windo,cres,ndof,coord,khdr,istep)
c.....cres destroyed in formfs
      trdis=trdis+rdis
      jskis=jskis+1
      jskip=jskip+1
      call solve (f,ndof,iele,cres,stressn,d0,icode,idat,dummy,ndatam,
     +propma,iface,numeqn,neq,btol,iadres,s,coord,fr,iconv,nck,nter,ener
     +,dissi,trdis,pfac,rdisp0,kstiff,windo,lmdat,ekdat,bdat,porel,istep
     +,enerb,nbms)
      call copr (dummy(1),fr(1),numeqn)
      if (jskis .ge. iskis) then
         call save (f,fr,cres,dummy,ndof,time)
         jskis=0
      endif
      call workdn (f,fr,dummy,work,neq,windo)
      enerin=ener-ener0
      diff=work-(enerin+enerb-enerb0)
      dissi=dissi-diss0
c      diff=work+ener0+diss0-ener
c.....check for eigen solution at each step. Now the stiffness matrix is
c     decomposed for the next step. Take into consideration that fact.
      if (keig .lt. 0  .and.  kstiff .ne. 0) then
         kstiff=0
         llast=1+ncel*ndt
         mavl=(mxk-ncel)*ndt
         meig=-keig
         call assemk (iadres,s,lmdat,ekdat)
         call eigsol (iadres,s,idat(llast),neq,nsto,0.D0,meig,mavl,
     +   imass,windo,prd1)
         call assemk (iadres,s,lmdat,ekdat)
         call optsol (s,fr,iadres,numeqn,1,1,1)
      else
         continue
      endif
c
      call telapsd (mtime,itime)
      write (ntr,1002) time,work,enerin,diff,dissi,prd1,wlf,mtime
      ebr=0.d0
      istep=istep+1
c      if (istep .gt. kstep) return
      time=time+1.0
      go to 50
c
 1000 format (//'** The control returned from incremental static',
     +' driver DISPS after:',i5,' steps **')
 1001 format (' Incremental static solution, step no:',i4)
 1002 format (7e14.6,i10)
c
      end
c     -------------------------------------------------------------------FORMFS
      subroutine formfs (f,fr,dummy,s,iadres,numeqn,neq,kfrc,kdis,ifc,
     + idis,trdis,pfac,pfai,windo,cres,ndof,coord,khdr,istep)
      implicit double precision (a-h,o-z)
      dimension f(1),fr(1),dummy(1),s(1),iadres(1),windo(1),cres(1),
     +ndof(1),coord(1)
c
c.....Develops the equivalent load vector in the beginning of a step
c
c                                           Sudip S. Bhattacharjee/Feb.23/1992
c                                           modified              /Sep.24/1993
      nn=numeqn+1
      nterm=neq-numeqn
      if (kdis .ge. istep) then
         call bakup (fr,neq,-idis,windo)
         call copr (fr(nn),dummy(nn),nterm)
         call addr (f(nn),fr(nn),nterm)
      else
         continue
      endif
      call izero (fr,2*neq)
      if (trdis .ne. 0.d0) then
c         dpfac=pfac*rdis/trdis
         dpfac=pfac-pfai
         print*, pfac,pfai,dpfac
         pfai=pfac
         pfac=pfac+dpfac
      endif
      if (kfrc .ge. istep) then
         call bakup (fr,numeqn,-ifc,windo)
         if (trdis .ne. 0.d0) then
            do 100 i=1,numeqn
               fr(i)=fr(i)*dpfac
  100       continue
         endif
         call addr (dummy,fr,numeqn)
      else
         continue
      endif
c.....Modification for the reservoir filling option
      if (khdr .ge. istep) then
          call modhdr (cres,ndof,coord,windo,fr,dummy,trdis,dpfac,kfrc)
      endif
c.....Partitioning for the displacement boundary conditions
      if (kdis .eq. 0) return
      do 300 ii=nn,neq
         ki=iadres(ii-1)+1
         kj=iadres(ii)-1
         kk=ii-kj-1
         do 200 k=ki,kj
            ieq=kk+k
            fr(ieq)=fr(ieq)-s(k)*dummy(ii)
  200    continue
  300 continue
c
      return
      end
c     ------------------------------------------------------------------MODHDR
      subroutine modhdr (cres,ndof,coord,windo,fr,dummy,trdis,dpfac,
     +kfrc)
      implicit double precision (a-h,o-z)
      dimension cres(1),ndof(1),coord(1),windo(1),fr(1),dummy(1)
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
      common /bacup/ nvec,imass(3),ifc,idis,idisp,irest,iwet,ifls(3)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c.....Adds the incremental hydrostatic pressure load to the upstream face
c
c                                                 Sudip S.B./Sept.24,1993/Ecole
c
      if (trdis .ne. 0.d0  .and.  kfrc .eq. 0) then
          wlt=wlf+dwl*dpfac
          if (wlt .lt. cwl) wlt=cwl
      else
         wlt=wlf+dwl
         if (wlt .lt. 0.d0) wlt=0.d0
      endif
      if (dabs(wlt-wlf) .lt. 1.0e-10) then
         write (not,5001) wlf
         write (ntm,5001) wlf
         khdr=0
         return
      endif
      dps=wlt-wlf
      call izero (cres,2*neq)
      call hfors (cres,ndof,coord,windo(iwet),hforce)
      do 110 i=1,neq
  110 cres(i)=-cres(i)
      wlf=wlf+dps
      dps=dps*uw
      call setnwl (windo(iwet),coord)
      call hfors (cres,ndof,coord,windo(iwet),hforce)
      write (not,3004) hforce
      write (ntm,3004) hforce
      call addr (fr,cres,numeqn)
      call addr (dummy,cres,numeqn)
c      if (ipor .ne. 0) then
c         do 310 n=1,numel
c            do 300 i=1,4
c               porel(i,n)=porel(i,n)+dps
c  300       continue
c  310    continue
c      endif
c
 3004 format (/' The total horizontal thrust from water=',e13.7)
 5001 format (/'** Reservoir level is retained constant at :',f12.5)
c
      return
      end
c     --------------------------------------------------------------------SOLVE
      subroutine solve (f,ndof,iele,cres,stressn,d0,icode,idat,dummy,
     +ndatam,propma,iface,numeqn,neq,btol,iadres,s,coord,fr,iconv,nck,
     +nter,ener,dissi,trdis,pfac,rdisp0,kstiff,windo,lmdat,ekdat,bdat,
     +porel,istep,enerb,nbms)
      implicit double precision (a-h, o-z)
      Character*16 state
c
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      dimension f(1),ndof(1),iele(1),cres(1),stressn(1),d0(1),icode(1),
     +idat(1),dummy(1),propma(1),iface(1),iadres(1),s(1),coord(1),fr(1),
     +nck(1),windo(1),lmdat(1),ekdat(1),bdat(1),porel(1)
c.....This routine iterates for removal of load unbalance
c                                  Sudip S.B./February 22,192/McGill
c
      itr=0
      dps=0.d0
  100 continue
      itr=itr+1
  	call optsol (s,fr,iadres,numeqn,1,1,2)
      call addr (f,fr,numeqn)
      f(neq+1)=0.d0
c.....checking for relative displacement control
      if (trdis .ne. 0.d0) then 
         call reldis (f,fr,trdis,pfac,dummy,btol,rdisp0,windo,ndof,
     +   coord,cres,s,iadres,istep)
      endif
c.....cres has been destroyed in reldis
      call ex_es (f,ndof,iele,cres,stressn,d0,icode,idat,iconv,fr,
     +ndatam,propma,iface,nck,ener,dissi,windo,lmdat,ekdat,bdat,porel,
     +coord,enerb)
c.....Correcting the load vector for changes in pore-pressure
      if (ipor .ne. 0  .and.  ncrk .gt. 0) then
         call crkpor (porel,bdat,iele,icode,idat,ndof,dummy,nck,
     +   ncel,ndt)
      endif
c.....checking for residual norm
      call norm (fr,neq,fmax)
      call resid (dummy,fr,numeqn)
      call norm (fr,numeqn,rmax)
      if (fmax .lt. 1.0e-5) then
         fnorm=rmax
      else
         fnorm=rmax/fmax
      endif
      if (fnorm .gt. btol) iconv=1
      if (iconv .eq. 0  .or.  itr .ge. nter) go to 400
      if (ipd .eq. 1) go to 500
      go to 100
  400 continue
      if (iconv .eq. 1) then
         state='DID NOT CONVERGE'
         itr=nter
         iconv=0
      else
         state='CONVERGED'
      endif
      enert=ener+enerb
      write (not,1001) dble(istep),itr,fnorm,state,enert,ncrk
      write (ntm,1001) dble(istep),itr,fnorm,state,enert,ncrk
      if (nbms .ne. 0) call sumbms (dble(istep),ekdat,nbms)
      if (ncrk .eq. 0) return
  500 continue
      if (istiff .eq. 0) go to 510
         kstiff=1
         call assemk (iadres,s,lmdat,ekdat)
         call optsol (s,fr,iadres,numeqn,1,1,1)
  510 continue
      if (iconv .eq. 0) return
      go to 100
c
 1001 format (//'ANALYSIS SUMMARY'/'STEP:',f10.5,2x,'Iterations:',i4,2x,
     +'Residual Norm',d12.6,2x,'(',a16,')'/'Current strain energy in ',
     +'the system:',e18.10/'Total no of crack profiles:',i5)
c
      return
      end
c     -------------------------------------------------------------------WORKDN
      subroutine workdn (disp,fr,dummy,work,neq,windo)
      double precision disp(1),fr(1),dummy(1),work,windo(1)
      common /bacup/ nvec,imass,idead,iep0,ifc,idis,idisp,irest,ifals(4)
c
      call bakup (dummy,neq,-irest,windo)
      do 100 i=1,neq
         dummy(i)=0.5*(dummy(i)+fr(i))
  100 continue
      call bakup (fr,neq,irest,windo)
      call bakup (fr,neq,-idisp,windo)
      do 200 i=1,neq
         work=work+dummy(i)*(disp(i)-fr(i))
  200 continue
      call bakup (dummy,neq,-irest,windo)
      call bakup (disp,neq,idisp,windo)
      call bakup (dummy,neq,irest,windo)
c
      return
      end
c     -------------------------------------------------------------------RELDIS
      subroutine reldis (f,fr,trdis,pfac,dummy,btol,rdisp0,windo,ndof,
     +coord,cres,s,iadres,istep)
      implicit double precision (a-h,o-z)
      dimension f(1),fr(1),dummy(1),windo(1),ndof(1),coord(1),cres(1),
     +s(1),iadres(1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /andat/ rdis,kswt,kdis,kfrc,ktmp,khdr,kseis(2),n1dof,n2dof
      common /bacup/ nvec,imass(3),ifc,idis,idisp,irest,iwet,ifls(3)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
c.....Adjusts the applied load depending the current relative displacement
c                        Sudip S. B./McGill/June 28,1992
c                        modified   /Ecole/Oct. 06,1993
      disp=f(n2dof)-f(n1dof)
      ttdis=trdis+rdisp0
      diff=ttdis-disp
      fnrm=diff/trdis
      if (dabs(fnrm) .lt. btol) return
      print*, ttdis,disp,diff
      call izero (fr,2*neq)
      if (khdr .ge. istep  .and.  kfrc .eq. 0) then
c........the applied reservoir pressure vector
         call hfors (fr,ndof,coord,windo(iwet),hforce)
         do 200 i=1,neq
            fr(i)=-fr(i)
  200    continue
         wlx=wlf
         wlf=wlf+dwl
c        call setnwl (windo(iwet),coord)
         call hfors (fr,ndof,coord,windo(iwet),hforce)
         wlf=wlx
      endif
c.....The applied load vector
      if (kfrc .ge. istep) then
         call bakup (cres,numeqn,-ifc,windo)
         call addr (fr,cres,numeqn)
      endif
      if (kfrc .lt. istep  .and.  khdr .lt. istep) return
      call copyr (cres,fr,numeqn)
      call optsol (s,fr,iadres,numeqn,1,1,2)
      fr(neq+1)=0.d0
      disr=fr(n2dof)-fr(n1dof)
      dpfac=diff/disr
c
      if (khdr .ge. istep  .and.  kfrc .eq. 0) then
          dps=dwl*dpfac
          wlt=wlf+dps
          if (wlt .lt. cwl) then
             dpfac=dpfac*(cwl-wlf)/dps
             wlt=cwl
             write (not,5001) wlt
             write (ntm,5001) wlt
             khdr=0
          else
             write (not,5002) wlt
             write (ntm,5002) wlt
          endif
          dps=(wlt-wlf)
          wlf=wlf+dps
c          if (ipor .ne. 0) then
c             dps=dps*uw
c             do 320 n=1,numel
c                do 310 i=1,4
c                   porel(i,n)=porel(i,n)+dps
c  310           continue
c  320        continue
c           endif
      endif
c
      pfac=pfac+dpfac
c
      do 300 i=1,numeqn
         cres(i)=cres(i)*dpfac
         dummy(i)=dummy(i)+cres(i)
         fr(i)=fr(i)*dpfac
         f(i)=f(i)+fr(i)         
  300 continue
c
 5001 format (/'** Reservoir level will remain constant at :',f12.5)
 5002 format (/'** The adjusted water level is:',f12.5,' **')
c
      return
      end
c     -------------------------------------------------------------------OUTP
      subroutine outp (iskis,iskip)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c.....Input the output control parameters
c                        Sudip S. B./Ecole/Feb 03,1994
c
      kt=0
      call find ('OUTP',kt)
      iskis=1
      iskip=1
      if (kt .eq. 0) then
         call free
         call freei ('S',iskis,1)
         call freei ('P',iskip,1)
      endif
      write (not,1001) iskis,iskip
      write (ntm,1001) iskis,iskip
c
 1001 format (//'The nodal and element responses will be saved at an',
     +' interval of:',i6/'The crack profiles (if any) will be saved at',
     +' an interval of    :',i6/5x,'Note: The energy response will be',
     +' saved at each step.')
c
      return
      end
